#ifndef SmartLab_MuRata_Type_WIFINetwork
#define SmartLab_MuRata_Type_WIFINetwork

#include "WIFIInfo.h"
#include "mbed.h"

namespace SmartLabMuRata
{
class WIFINetwork : public WIFIInfo
{
private :
    char * key;
    char * bssid;

public:
    const char * GetSecurityKey();

    const char * GetBSSID();

    WIFINetwork();

    WIFINetwork(const char * SSID, const SecurityMode securityMode, const char * securityKey = NULL);
    
    virtual ~WIFINetwork();

    virtual WIFINetwork * SetSecurityKey(const char * SecurityKey);

    virtual WIFINetwork * SetBSSID(const char * BSSID);

    virtual WIFINetwork * SetSSID(const char * SSID);

    virtual WIFINetwork * SetSecurityMode(const SecurityMode securityMode);

    virtual WIFINetwork * SetChannel(const char channel);
};
}

#endif