#ifndef SmartLab_MuRata_Type_WIFIInfo
#define SmartLab_MuRata_Type_WIFIInfo

#include "SecurityMode.h"
#include <string>

using namespace std;

namespace SmartLabMuRata
{
class WIFIInfo
{
private :
    /**
    * must be none 0 value, when used ad AP control.
    */
    char channel;
    
    char * ssid;
    
    SecurityMode mode;

public:
    const char * GetSSID();

    SecurityMode GetSecurityMode();

    char GetChannel();

    WIFIInfo();

    WIFIInfo(const char * SSID, const SecurityMode securityMode);

    virtual ~WIFIInfo();

    virtual WIFIInfo * SetSSID(const char * SSID);

    virtual WIFIInfo * SetSecurityMode(const SecurityMode securityMode);

    virtual WIFIInfo * SetChannel(const char channel);

    const char * ToString();
};
}

#endif