#ifndef SmartLab_MuRata_Type_HTTPContent
#define SmartLab_MuRata_Type_HTTPContent

#include <string>
#include <map>

#include "HTTPMethod.h"

using namespace std;

namespace SmartLabMuRata
{
class HTTPContent
{
private:
    const static char HEADER_SEPARATE[];
    const static char HEADER_TEMINATE[];

    int remotePort;
    int contentLength;
    HTTPMethod method;
    char timeout;
    
    string remoteHost;
    string uri;
    string contentType;

    map<const char *, const char *> otherHeaders;

    char * body;

    /// <summary>
    /// URI, Content Type, and Other header are all NUL terminated char strings. URI must be specified, e.g., “index.htm”. If Content Type is an empty string, the default will be “text/plain”. If it is a GET,
    /// </summary>
    /// <param name="method"></param>
    /// <param name="remoteHost"></param>
    /// <param name="remotePort"></param>
    /// <param name="uri"></param>
    /// <param name="timeout"></param>
    /// <param name="contentType"></param>
public :

    HTTPContent(const HTTPMethod method, const char * remoteHost,const int remotePort,const char * uri,const char timeout, const char * contentType = NULL);

    ~HTTPContent();

    HTTPMethod GetMethod();

    HTTPContent * SetMethod(const HTTPMethod method);

    char GetTimeout();

    /// <summary>
    /// Timeout is in seconds. If Timeout is 0, it means wait forever. A complete HTTP request will block other commands until either a response is received or timeout. So timeout value of 0 is not recommended. If timeout happens, the response status code would be SNIC_TIMEOUT. If it is chunked encoding in the response, the last chunk should be received before Timeout; otherwise, the connection is closed. If the HTTP request has more data to send (POST), it is not considered a complete HTTP request, and other commands are not blocked until the series of SNIC_HTTP_MORE_REQ are finished.
    /// </summary>
    /// <param name="timeout"></param>
    /// <returns></returns>
    HTTPContent * SetTimeout(const char timeout);

    int GetRemotePort();

    HTTPContent * SetRemotePort(const int port);

    const char * GetRemoteHost() ;

    HTTPContent * SetRemoteHost(const char * host);

    const char * GetURI();

    HTTPContent * SetURI(const char * uri) ;

    const char * GetContentType();

    HTTPContent * SetContentType(const char * contentType);

    //const string * GetOtherHeader(const string * key);

    HTTPContent * SetOtherHeader(const char * key, const char * value);

    void GetOtherHeaders(string * headers);

    const char * GetBody();

    HTTPContent * SetBody(char * body, int offset, int length);

    HTTPContent * ClearBody();

    int GetContentLength();

};
}

#endif