#include "HTTPResponse.h"

using namespace SmartLabMuRata;

HTTPResponse::HTTPResponse(Payload * payload)
    : Payload(payload)
{
    if (payload == NULL)
        return;
        
    statusCode = GetData()[2] << 8 | GetData()[3];
    if (statusCode >= 100) {
        contentLength = (GetData()[4] & 0x7F) << 8 | GetData()[5];
        contentType.assign(GetData() + 6);
        payloadOffset = 6 + contentType.length() + 1;

        GetData()[payloadOffset + contentLength] = 0x00;
    }
}

bool HTTPResponse::isMoreDataComing()
{
    return (GetData()[4] >> 7) == 0x01 ? true : false;
}

int HTTPResponse::GetContentLength()
{
    return contentLength;
}

int HTTPResponse::GetStatusCode()
{
    return statusCode;
}

char HTTPResponse::GetContent(int index)
{
    return GetData()[index + payloadOffset];
}

const char * HTTPResponse::GetContent()
{
    return GetData() + payloadOffset;
}

string & HTTPResponse::GetContentType()
{
    return contentType;
}

int HTTPResponse::GetContentOffset()
{
    return payloadOffset;
}