#include "UDPReceivedIndication.h"

using namespace SmartLabMuRata;

UDPReceivedIndication::UDPReceivedIndication(Payload * payload)
    : Payload(payload)
{
    if (payload == NULL)
        return;
        
    receiveLength = GetData()[9] << 8 | GetData()[10];
}

char UDPReceivedIndication::GetServerSocketID()
{
    return GetData()[2];
}

IPAddress UDPReceivedIndication::GetRemoteIP()
{
    IPAddress ip;
    ip.SetValue(GetData(), 3);
    return ip;
}

int UDPReceivedIndication::GetRemotePort()
{
    return GetData()[7] << 8 | GetData()[8];
}

int UDPReceivedIndication::GetPayloadLength()
{
    return receiveLength;
}

char UDPReceivedIndication::GetPayload(int index)
{
    return GetData()[index + PAYLOAD_OFFSET];
}

const char * UDPReceivedIndication::GetPayload()
{
    return GetData() + PAYLOAD_OFFSET;
}

int UDPReceivedIndication::GetPayloadOffset()
{
    return PAYLOAD_OFFSET;
}