#ifndef SmartLab_MuRata_Indication_SocketReceiveInidcation
#define SmartLab_MuRata_Indication_SocketReceiveInidcation

#include "Payload.h"

namespace SmartLabMuRata
{
/// <summary>
/// This event is generated when a TCP server or a UDP server (in connected mode) receives a packet. Since there is no client address and port information, the application may need to call
/// </summary>
class SocketReceiveInidcation : public Payload
{
private:
    int receiveLength;

public:
    static const int PAYLOAD_OFFSET = 5;

    SocketReceiveInidcation(Payload * payload);

    char GetServerSocketID() ;

    int GetPayloadLength();

    char GetPayload(int index);

    const char * GetPayload();

    /// <summary>
    /// Get the start index of the payload
    /// </summary>
    /// <returns></returns>
    int GetPayloadOffset();
};
}

#endif