#include "SSIDRecordIndication.h"

using namespace SmartLabMuRata;

SSIDRecordIndication::SSIDRecordIndication(Payload * payload)
    : Payload(payload)
{}

int SSIDRecordIndication::GetNumberofRecords()
{
    return GetData()[2];
}

void SSIDRecordIndication::GetRecords(WIFINetworkDetail * details)
{
    int count = GetNumberofRecords();

    if (count <= 0)
        return;
        
    int index = 0;
    int _position = 3;

    const char * value = GetData();

    while (index < count) {
        
        (details + index)->SetChannel(value[_position++])
        ->SetRSSI(value[_position++])
        ->SetSecurityMode((SecurityMode)value[_position++])
        ->SetBSSID(value + _position)
        ->SetNetworkType((BSSType)value[_position += 6])
        ->SetMaxDataRate(value[_position++])
        ->SetSSID(value + (_position += 2));

        _position+= strlen((details + index)->GetSSID()) + 1;
        
        index++;
    }
}