#ifndef SmartLab_MuRata_Indication_HTTPResponseIndication
#define SmartLab_MuRata_Indication_HTTPResponseIndication

#include "Payload.h"

namespace SmartLabMuRata
{
/// <summary>
/// The most significant bit of Content length is reserved to indicate if there is more data to send to the host. When this bit is 1, the host application should continue to receive SNIC_HTTP_RSP_IND, until this bit is 0. The Content length is limited by the receive buffer size specified in SNIC_INIT_REQ and the system resource at that moment.
/// </summary>
class HTTPResponseIndication : public Payload
{
private :
    int contentLength;

    public :
    
    static const int PAYLOAD_OFFSET = 4;
    
    HTTPResponseIndication(Payload * payload);

    /// <summary>
    /// The most significant bit of Content length is reserved to indicate if there is more data to send to the host. When this bit is 1, the host application should continue to receive SNIC_HTTP_RSP_IND, until this bit is 0. The Content length is limited by the receive buffer size specified in SNIC_INIT_REQ and the system resource at that moment.
    /// </summary>
    /// <returns></returns>
    bool isMoreDataComing();
    
    int GetContentLength();

    char GetContent(int index);
    
    const char * GetContent();

    /// <summary>
    /// Get the start index of the content
    /// </summary>
    /// <returns></returns>
    int GetContentOffset();
};
}

#endif