#ifndef SmartLab_MuRata_Config_UARTConfig
#define SmartLab_MuRata_Config_UARTConfig

#include "IConfig.h"

namespace SmartLabMuRata
{
class UARTConfig : public IConfig
{
    /*
     * Parameters are as follows:
     * UINT8 Request Sequence
     * UINT8 Port
     * UINT8 Format
     * UINT32 Baud
     * Port specifies the UART port. Valid value is 1.
     */

    //Data 0x10 8 data bits
private :
    char value[6];

public:

    enum FlowControl { NoFlowControl = 0x00, HardwareFlowControl = 0x20, };
    enum Parity { None = 0x00, Odd = 0x40, Even = 0x80, };
    enum StopBits { StopBit1 = 0x01, StopBit2 = 0x02, };
    enum BaudRate { _9600 = 9600, _19200 = 19200, _38400 = 38400, _57600 = 57600, _115200 = 115200, _230400 = 230400, _460800 = 460800, _921600 = 921600 };

    virtual const char * GetValue();

    virtual int GetValueLength();

    UARTConfig(const FlowControl flowControl, const Parity parity, const StopBits StopBits, const BaudRate baudRate);

    UARTConfig * SetFlowControl(const FlowControl flowControl);

    UARTConfig * SetParity(const Parity parity);

    UARTConfig * SetStopBits(const StopBits stop);

    UARTConfig * SetBaudRate(const BaudRate baudRate);
};
}

#endif