#include "IOSamples.h"

map<Pin *, unsigned int> * IOSamples::getAnalogs()
{
    return &analog;
}

unsigned int IOSamples::getAnalog(Pin * pin)
{
    if (analog.count(pin))
        return analog[pin];
    else return 0xFFFF;
}

map<Pin *, unsigned char> * IOSamples::getDigitals()
{
    return &digital;
}

unsigned char IOSamples::getDigital(Pin * pin)
{
    if (digital.count(pin))
        return digital[pin];
    else return 2;
}

unsigned int IOSamples::getSupplyVoltage()
{
    return SUPPLY_VOLTAGE;
}

void IOSamples::setSupplyVoltage(unsigned int voltage)
{
    SUPPLY_VOLTAGE =  voltage;
}

void IOSamples::clear()
{
    analog.clear();
    digital.clear();
}