#include "ZigBeeTxRequest.h"

ZigBeeTxRequest::ZigBeeTxRequest(unsigned  char frameID, Address * remoteAddress, OptionsBase * transmitOptions, const unsigned char * payload, int offset, int length)
    : TxBase(9 + length, APIFrame::ZigBee_Transmit_Request, frameID)
{
    sets(remoteAddress->getAddressValue(), 0, 10);
    set(0x00);
    set(transmitOptions->getValue());
    sets(payload, offset, length);
}

void ZigBeeTxRequest::setPayload(const unsigned  char * data, int offset, int length)
{
    setPosition(14);
    sets(data, offset, length);
}

void ZigBeeTxRequest::setTransmitOptions(OptionsBase * transmitOptions)
{
    data[13] = transmitOptions->getValue();
}

void ZigBeeTxRequest::setRemoteAddress(Address * remoteAddress)
{
    sets(2, remoteAddress->getAddressValue(), 0, 10);
}


void ZigBeeTxRequest::setBroadcastRadius(unsigned  char broadcastRadius)
{
    data[12] = broadcastRadius;
}