#include "XBeeTx64Request.h"

XBeeTx64Request::XBeeTx64Request(unsigned  char frameID, Address * remoteAddress, OptionsBase * transmitOptions, const unsigned char * payload, int offset, int length)
    : TxBase(9 + length, APIFrame::Tx64_Request, frameID)
{
    sets(remoteAddress->getAddressValue(), 0, 8);
    set(transmitOptions->getValue());
    sets(payload, offset, length);
}

void XBeeTx64Request::setPayload(const unsigned char * data, int offset, int length)
{
    setPosition(11);
    sets(data, offset, length);
}

void XBeeTx64Request::setTransmitOptions(OptionsBase * transmitOptions)
{
    data[10] = transmitOptions->getValue();
}

void XBeeTx64Request::setRemoteAddress(Address * remoteAddress)
{
    sets(2, remoteAddress->getAddressValue(), 0, 8);
}