#include "ATCommandRequest.h"

ATCommandRequest::ATCommandRequest(unsigned  char frameID, const char * command, const unsigned  char * parameter, int offset, int length)
    : TxBase(2 + (parameter == NULL ? 0 : length), APIFrame::AT_Command, frameID)
{
    set(command[0]);
    set(command[1]);

    if (parameter != NULL)
        sets(parameter, offset, length);
}

void ATCommandRequest::setAppleChanges(bool appleChanges)
{
    if (appleChanges)
        setFrameType(APIFrame::AT_Command);
    else
        setFrameType(APIFrame::AT_Command_Queue_Parameter_Value);
}

void ATCommandRequest::setCommand(const char * command)
{
    set(2, command[0]);
    set(3, command[1]);
}

void ATCommandRequest::setParameter(const unsigned  char * parameter, int offset, int length)
{
    setPosition(4);
    sets(parameter, offset, length);
}