#include "OptionsBase.h"

OptionsBase::OptionsBase()
{
    value = 0x00;
}

OptionsBase::OptionsBase(unsigned char option)
{
    value = option;
}

OptionsBase * OptionsBase::DEFAULT = new OptionsBase();

OptionsBase * OptionsBase::DisableRetriesRouteRepair = new OptionsBase(0x01);

bool OptionsBase::getDisableRetriesRouteRepair()
{
    if ((value & 0x01) == 0x01)
        return true;
    else return false;
}

void OptionsBase::setDisableRetriesRouteRepair(bool status)
{
    if (status)
        value |= 0x01;
    else
        value &= 0xFE;
}

unsigned char OptionsBase::getValue()
{
    return value;
}