#ifndef UK_AC_HERTS_SMARTLAB_XBEE_ZigBeeIOSampleIndicator
#define UK_AC_HERTS_SMARTLAB_XBEE_ZigBeeIOSampleIndicator

#include "RxBase.h"
#include "Address.h"
#include "IOSamples.h"
#include "ISampleResponse.h"

class ZigBeeIOSampleIndicator: public ISampleResponse, public RxBase
{
public:
    ZigBeeIOSampleIndicator(APIFrame *frame);

    virtual int getRSSI();

    virtual IOSamples * getIOSamples();
    
    virtual int getSamplesCount();

    /**
    * bit mask
    * SUCCESS = 0x00,
    * PACKET_ACKNOWLEDGED = 0x01,
    * PACKET_WAS_A_BROADCAST = 0x02,
    * PACKET_RECEIVED_ON_BOARDCAST_PAN = 0x04,
    * PACKET_ENCRYPTED_WITH_APS_ENCRYPTION = 0x20,
    * PACKET_WAS_SENT_FROM_AN_END_DEVICE = 0x40,
    */
    virtual int getReceiveStatus();

    virtual Address getRemoteDevice();
    
    bool convert(APIFrame * frame);
};

#endif