#ifndef UK_AC_HERTS_SMARTLAB_XBEE_RouteRecordIndicator
#define UK_AC_HERTS_SMARTLAB_XBEE_RouteRecordIndicator

#include "Address.h"
#include "RxBase.h"

class RouteRecordIndicator : public RxBase
{
public:
    RouteRecordIndicator(APIFrame * frame);

    Address getRemoteDevice();

    /**
    * bit mask
    * SUCCESS = 0x00,
    * PACKET_ACKNOWLEDGED = 0x01,
    * PACKET_WAS_A_BROADCAST = 0x02,
    * PACKET_RECEIVED_ON_BOARDCAST_PAN = 0x04,
    * PACKET_ENCRYPTED_WITH_APS_ENCRYPTION = 0x20,
    * PACKET_WAS_SENT_FROM_AN_END_DEVICE = 0x40,
    */
    int getReceiveStatus();

    int getNumberOfAddresses();

    /** Array of NET16 address
    * index is [0, getNumberOfAddresses() -1], -1 means not avaliable
    */
    int getAddresses(int index);
    
    bool convert(APIFrame * frame);
};

#endif
