#include "RemoteCommandIndicator.h"

RemoteCommandIndicator::RemoteCommandIndicator(APIFrame * frame)
    : RxBase(frame)
{}

int RemoteCommandIndicator::getFrameID()
{
    return data[1];
}

unsigned  char * RemoteCommandIndicator::getRequestCommand()
{
    return data + 12;
}

int RemoteCommandIndicator::getCommandStatus()
{
    return data[14];
}

Address RemoteCommandIndicator::getRemoteDevice()
{
    return Address(data + 2);
}

unsigned  char * RemoteCommandIndicator::getParameter()
{
    if (getParameterLength() <= 0)
        return NULL;

    return data + 15;
}

unsigned char RemoteCommandIndicator::getParameter(int index)
{
    return data[15 + index];
}

int RemoteCommandIndicator::getParameterLength()
{
    return getPosition() - 15;
}

int RemoteCommandIndicator::getParameterOffset()
{
    return 15;
}

bool  RemoteCommandIndicator::convert(APIFrame * frame)
{
    if (frame == NULL)
        return false;

    if (frame->getFrameType() != APIFrame::Remote_Command_Response)
        return false;

    return APIFrame::convert(frame);
}
