#ifndef UK_AC_HERTS_SMARTLAB_XBEE_NodeIdentificationIndicator
#define UK_AC_HERTS_SMARTLAB_XBEE_NodeIdentificationIndicator

#include "Address.h"
#include "RxBase.h"

class NodeIdentificationIndicator : public RxBase
{
private:
    int offset;

public:
    NodeIdentificationIndicator(APIFrame * frame);

    /**
    *
    * @returns
    * bit mask
    *       SUCCESS = 0x00,
    *       PACKET_ACKNOWLEDGED = 0x01,
    *       PACKET_WAS_A_BROADCAST = 0x02,
    *       PACKET_RECEIVED_ON_BOARDCAST_PAN = 0x04,
    *       PACKET_ENCRYPTED_WITH_APS_ENCRYPTION = 0x20,
    *       PACKET_WAS_SENT_FROM_AN_END_DEVICE = 0x40,
    *
    */
    int getReceiveStatus();

    Address getRemoteDevice();

    Address getSenderDevice();

    unsigned  char * getNIString();

    int getParentNetworkAddress();

    /*
    *
    * @returns
    *        COORDINATOR = 0x00,
    *        ROUTER = 0x01,
    *        END_DEVICE = 0x02,
    *
    */
    int getDeviceType();

    /*
    *
    * @returns
    *    FRAME_SENT_BY_NODE_IDENTIFICATION_PUSHBUTTON_EVENT = 0x01,
    *    FRAME_SENT_AFTER_JOINING_EVENT_OCCURRED = 0x02,
    *    FRAME_SENT_AFTER_POWER_CYCLE_EVENT_OCCURRED = 0x03,
    *
    */
    int getSourceEvent();

    int getDigiProfileID();

    int getManufacturerID();
    
    bool convert(APIFrame * frame);
};

#endif
