#include "NodeIdentificationIndicator.h"

NodeIdentificationIndicator::NodeIdentificationIndicator(APIFrame * frame)
    : RxBase(frame)
{
    offset = getPosition() - 8;
}

int NodeIdentificationIndicator::getReceiveStatus()
{
    return data[11];
}

Address NodeIdentificationIndicator::getRemoteDevice()
{
    return Address(data + 14, data + 8);
}

Address NodeIdentificationIndicator::getSenderDevice()
{
    return Address(data + 1);
}

unsigned  char * NodeIdentificationIndicator::getNIString()
{
    int length = getPosition() - 31;

    if (length <= 0)
        return NULL;

    return data + 22;
}

int NodeIdentificationIndicator::getParentNetworkAddress()
{
    return (data[offset] << 8) | data[offset + 1];
}

int NodeIdentificationIndicator::getDeviceType()
{
    return data[offset + 2];
}

int NodeIdentificationIndicator::getSourceEvent()
{
    return data[offset + 3];
}

int NodeIdentificationIndicator::getDigiProfileID()
{
    return (data[offset + 4] << 8) | data[offset + 5];
}

int NodeIdentificationIndicator::getManufacturerID()
{
    return (data[offset + 6] << 8) | data[offset + 7];
}

bool  NodeIdentificationIndicator::convert(APIFrame * frame)
{
    if (frame == NULL)
        return false;

    if (frame->getFrameType() != APIFrame::Node_Identification_Indicator)
        return false;

    return APIFrame::convert(frame);
}