#ifndef UK_AC_HERTS_SMARTLAB_XBEE_IPayloadResponse
#define UK_AC_HERTS_SMARTLAB_XBEE_IPayloadResponse

#include "Address.h"

class IPayloadResponse
{
public:
    /**
    * bit mask
    * SUCCESS = 0x00,
    * PACKET_ACKNOWLEDGED = 0x01,
    * PACKET_WAS_A_BROADCAST = 0x02,
    * PACKET_RECEIVED_ON_BOARDCAST_PAN = 0x04,
    * PACKET_ENCRYPTED_WITH_APS_ENCRYPTION = 0x20,
    * PACKET_WAS_SENT_FROM_AN_END_DEVICE = 0x40,
    */
    virtual int getReceiveStatus() = 0;

    virtual Address getRemoteDevice() = 0;

    virtual unsigned  char * getReceivedData() = 0;

    virtual int getReceivedDataOffset() = 0;

    virtual char getReceivedData(int index) = 0;

    virtual int getReceivedDataLength() = 0;

    /// <summary>
    /// not apply to ZigBee
    /// </summary>
    /// <returns></returns>
    virtual int getRSSI() = 0;
};

#endif