#ifndef UK_AC_HERTS_SMARTLAB_XBEE_ExplicitAddress
#define UK_AC_HERTS_SMARTLAB_XBEE_ExplicitAddress

#include "Address.h"

class ExplicitAddress : public Address
{
private:
    // total 6 bytes
    // 1 byte of SourceEndpoint + 1 byte of DestinationEndpoint + 2 bytes of ClusterID + 2 bytes of ProfileID
    unsigned char explicitValue[6];

public:
    ExplicitAddress() ;

    ExplicitAddress (const unsigned  char * AddressValue, const unsigned  char * ExplicitValue );

    ExplicitAddress(long SerialNumberHigh, long SerialNumberLow, int NetworkAddress, int SourceEndpoint, int DestinationEndpoint, int ClusterID, int ProfileID);

    /// <summary>
    /// total 6 bytes
    /// 1 byte of SourceEndpoint + 1 byte of DestinationEndpoint + 2 bytes of ClusterID + 2 bytes of ProfileID
    /// </summary>
    /// <returns></returns>
    unsigned  char * getExplicitValue();

    unsigned char getSourceEndpoint();

    void setSourceEndpoint(unsigned char SourceEndpoint);

    unsigned char getDestinationEndpoint();

    void setDestinationEndpoint(unsigned char DestinationEndpoint);

    unsigned int getClusterID();

    void setClusterID(unsigned int ClusterID);

    unsigned int getProfileID();

    void setProfileID(unsigned int ProfileID);
};

#endif