#include "ExplicitAddress.h"

ExplicitAddress::ExplicitAddress()
{ }

ExplicitAddress::ExplicitAddress (const unsigned  char * address, const unsigned  char * explicitAddress )
    : Address(address)
{
    memcpy(explicitValue, explicitAddress, 6);
}

ExplicitAddress::ExplicitAddress(long SerialNumberHigh, long SerialNumberLow, int NetworkAddress, int SourceEndpoint, int DestinationEndpoint, int ClusterID, int ProfileID)
    : Address(SerialNumberHigh, SerialNumberLow, NetworkAddress)
{
    explicitValue[0] = SourceEndpoint;
    explicitValue[1] = DestinationEndpoint;
    explicitValue[2] = ClusterID >> 8;
    explicitValue[3] = ClusterID;
    explicitValue[4] = ProfileID >> 8;
    explicitValue[5] = ProfileID;
}

unsigned  char * ExplicitAddress::getExplicitValue()
{
    return explicitValue;
}

unsigned char ExplicitAddress::getSourceEndpoint()
{
    return explicitValue[0];
}

void ExplicitAddress::setSourceEndpoint(unsigned char SourceEndpoint)
{
    explicitValue[0] = SourceEndpoint;
}

unsigned char ExplicitAddress::getDestinationEndpoint()
{
    return explicitValue[1];
}

void ExplicitAddress::setDestinationEndpoint(unsigned char DestinationEndpoint)
{
    explicitValue[1] = DestinationEndpoint;
}

unsigned int ExplicitAddress::getClusterID()
{
    return (explicitValue[2] << 8) | explicitValue[3];
}

void ExplicitAddress::setClusterID(unsigned int ClusterID)
{
    explicitValue[2] = ClusterID >> 8;
    explicitValue[3] = ClusterID;
}

unsigned int ExplicitAddress::getProfileID()
{
    return (explicitValue[4] << 8) | explicitValue[5];
}

void ExplicitAddress::setProfileID(unsigned int ProfileID)
{
    explicitValue[4] = ProfileID >> 8;
    explicitValue[5] = ProfileID;
}