#include "ZigBeeTxStatusIndicator.h"

ZigBeeTxStatusIndicator::ZigBeeTxStatusIndicator(APIFrame * frame)
    : RxBase(frame)
{ }

int ZigBeeTxStatusIndicator::getFrameID()
{
    return data[1];
}

int ZigBeeTxStatusIndicator::getDeliveryStatus()
{
    return data[5];
}

int ZigBeeTxStatusIndicator::getDestinationAddress16()
{
    return (data[2] << 8) | data[3];
}

int ZigBeeTxStatusIndicator::getTransmitRetryCount()
{
    return data[4];
}

int ZigBeeTxStatusIndicator::getDiscoveryStatus()
{
    return data[6];
}

bool  ZigBeeTxStatusIndicator::convert(APIFrame * frame)
{
    if (frame == NULL)
        return false;

    if (frame->getFrameType() != APIFrame::ZigBee_Transmit_Status)
        return false;

    return APIFrame::convert(frame);
}