#include "ZigBeeExplicitRxIndicator.h"

ZigBeeExplicitRxIndicator::ZigBeeExplicitRxIndicator(APIFrame * frame)
    : RxBase(frame)
{ }

unsigned  char * ZigBeeExplicitRxIndicator::getReceivedData()
{
    if (getReceivedDataLength() <=0)
        return NULL;

    return data + 18;
}

int ZigBeeExplicitRxIndicator::getReceivedDataOffset()
{
    return 18;
}

char ZigBeeExplicitRxIndicator::getReceivedData(int index)
{
    return data[18 + index];
}

int ZigBeeExplicitRxIndicator::getReceivedDataLength()
{
    return getPosition() - 18;
}

ExplicitAddress ZigBeeExplicitRxIndicator::getExplicitRemoteDevice()
{
    return ExplicitAddress(data + 1, data + 11);
}

Address ZigBeeExplicitRxIndicator::getRemoteDevice()
{
    return Address(data + 1);
}

int ZigBeeExplicitRxIndicator::getReceiveStatus()
{
    return data[17];
}

int ZigBeeExplicitRxIndicator::getRSSI()
{
    return 0;
}

bool  ZigBeeExplicitRxIndicator::convert(APIFrame * frame)
{
    if (frame == NULL)
        return false;

    if (frame->getFrameType() != APIFrame::ZigBee_Explicit_Rx_Indicator)
        return false;

    return APIFrame::convert(frame);
}