#include "Pin.h"

unsigned char Pin::bitfield[2] = {0,0};

Pin::Pin(unsigned char number)
{
    num = number;
}

Pin::Pin(unsigned char number, unsigned char msbCom, unsigned char lsbCom, unsigned char msbIODet, unsigned char lsbIODet)
{
    num = number;
    com[0] = msbCom;
    com[1] = lsbCom;
    IODet[0] = msbIODet;
    IODet[1] = lsbIODet;
}

unsigned char Pin::getNumber()
{
    return num;
}

char * Pin::getCommand()
{
    return com;
}

unsigned  char * Pin::IOChangeDetectionConfiguration(Pin ** pins, unsigned char size)
{
    Pin::bitfield[0] = 0;
    Pin::bitfield[1] = 0;
    for (int i = 0; i < size; i++) {
        Pin::bitfield[0] |= pins[i]->IODet[0];
        Pin::bitfield[1] |= pins[i]->IODet[1];
    }
    return Pin::bitfield;
}

unsigned  char * Pin::getIODetection()
{
    return IODet;
}

bool operator ==(const Pin &a,const Pin &b)
{
    return a.num == b.num;
}