#ifndef UK_AC_HERTS_SMARTLAB_XBEE_Address
#define UK_AC_HERTS_SMARTLAB_XBEE_Address

#include "mbed.h"

class Address
{
protected:
    // total 10 bytes
    // IEEE 64 + 16bit networ address
    unsigned char value[10];
public:
    static Address * BROADCAST_ZIGBEE;
    static Address * BROADCAST_XBEE;

    /// <summary>
    /// create empty address : 0x00000000 0x00000000 0x0000
    /// this is the default ZigBee Coordinatior
    /// </summary>
    Address();

    /// <summary>
    /// create address from byte[8 + 2] value : 8 bytes of ieee + 2 bytes network
    /// </summary>
    /// <param name="Address64"></param>
    /// <param name="NET16"></param>
    Address(const unsigned char * address64, const unsigned char * NET16);

    /// <summary>
    /// create address from byte[10] value : 8 bytes of ieee follow 2 bytes network
    /// </summary>
    /// <param name="value"></param>
    Address(const unsigned char * addr);

    Address(long serialNumberHigh, long serialNumberLow, int networkAddress);

    unsigned long getSerialNumberHigh();

    unsigned long getSerialNumberLow();

    unsigned int getNetworkAddress();

    void setSerialNumberHigh(long SerialNumberHigh);

    void setSerialNumberLow(long SerialNumberLow);

    void setNetworkAddress(int NetworkAddress);

    /// <summary>
    /// total 10 bytes
    /// IEEE 64 + 16bit networ address
    /// </summary>
    /// <returns></returns>
    const unsigned  char * getAddressValue();

    friend bool operator ==(const Address &a,const Address &b);

    friend bool operator !=(const Address &a,const Address &b);
};

#endif