#ifndef UK_AC_HERTS_SMARTLAB_XBEE_ISerial
#define UK_AC_HERTS_SMARTLAB_XBEE_ISerial

/// Serial data interface.
class ISerial
{
public:
    /** Read one byte data from the serila port.
    * @returns if success return non zero [0x00-0xFF], -1 means something is wrong
    */
    virtual int readByte() = 0;

    /** write one byte data to the serila port.
    * @param data [0x00-0xFF]
    */
    virtual void writeByte(char data) = 0;

    /// Check if the serial port is already open.
    virtual bool isOpen() = 0;

    /// Open the serila port.
    virtual void open() = 0;

    /// Close the serila port.
    virtual void close() = 0;
    
    /// Check if data is avaliable to read. 
    virtual bool peek() = 0;
};

#endif