#ifndef UK_AC_HERTS_SMARTLAB_XBEE_RemoteATCommandRequest
#define UK_AC_HERTS_SMARTLAB_XBEE_RemoteATCommandRequest

#include "TxBase.h"
#include "ICommandRequest.h"

class RemoteATCommandRequest : public TxBase, public ICommandRequest
{

public:
        //0x17
        //FrameID;
        //RemoteDevice
        //Remote Command Options
        //AT_Command
        //Parameter_Value

        /// <summary>
        /// 
        /// </summary>
        /// <param name="FrameID"></param>
        /// <param name="RemoteDevice"></param>
        /// <param name="options">RemoteCommandOptions</param>
        /// <param name="AT_Command"></param>
        /// <param name="Parameter_Value">this can be null</param>
        RemoteATCommandRequest(unsigned  char frameID, Address * remoteAddress, const char * command, OptionsBase * transmitOptions, const unsigned  char * parameter=NULL, int parameterOffset=0, int parameterLength=0);

        void setTransmitOptions(OptionsBase * transmitOptions);

        virtual void setAppleChanges(bool appleChanges);

        virtual void setCommand(const char * command);

        virtual void setParameter(const unsigned  char * parameter, int offset, int length);

        void setRemoteAddress(Address * remoteAddress);
};

#endif