#include "RemoteATCommandRequest.h"

RemoteATCommandRequest::RemoteATCommandRequest(unsigned  char frameID, Address * remoteAddress, const char * command, OptionsBase * transmitOptions, const unsigned  char * parameter, int parameterOffset, int parameterLength)
    : TxBase(13 + (parameter == NULL ? 0 : parameterLength), APIFrame::Remote_Command_Request, frameID)
{
    sets(remoteAddress->getAddressValue(), 0, 10);
    set(transmitOptions->getValue());
    set(command[0]);
    set(command[1]);

    if (parameter != NULL)
        sets(parameter, parameterOffset, parameterLength);
}

void RemoteATCommandRequest::setTransmitOptions(OptionsBase * transmitOptions)
{
    data[12] = transmitOptions->getValue();
}

void RemoteATCommandRequest::setAppleChanges(bool appleChanges)
{
    if (appleChanges)
       data[12] |= 0x02;
    else data[12] &= 0xFD;
}

void RemoteATCommandRequest::setCommand(const char * command)
{
    set(13, command[0]);
    set(14, command[1]);
}

void RemoteATCommandRequest::setParameter(const unsigned  char * parameter, int offset, int length)
{
    setPosition(15);
    sets(parameter, offset, length);
}

void RemoteATCommandRequest::setRemoteAddress(Address * remoteAddress)
{
    sets(2, remoteAddress->getAddressValue(), 0, 10);
}