#ifndef UK_AC_HERTS_SMARTLAB_XBEE_PinConfigurationRequest
#define UK_AC_HERTS_SMARTLAB_XBEE_PinConfigurationRequest

#include "Pin.h"
#include "ATCommands.h"
#include "ATCommandRequest.h"

class PinConfigurationRequest : public ATCommandRequest
{
public:
    /**
    * @param function
    *DISABLED = 0x00,
    *RESERVED_FOR_PIN_SPECIFIC_ALTERNATE_FUNCTIONALITIES = 0x01,
    *ANALOG_INPUT_SINGLE_ENDED = 0x02,
    *DIGITAL_INPUT_MONITORED = 0x03,
    *DIGITAL_OUTPUT_DEFAULT_LOW = 0x04,
    *DIGITAL_OUTPUT_DEFAULT_HIGH = 0x05,
    *ALTERNATE_FUNCTIONALITIES_WHERE_APPLICABLE = 0x06//0x06~0x09
    */
    PinConfigurationRequest(unsigned  char frameID, Pin * pin, unsigned char function)
        : ATCommandRequest(frameID, pin->getCommand(), &function, 0, 1)
    { }
    
    /**
    * @param function
    *DISABLED = 0x00,
    *RESERVED_FOR_PIN_SPECIFIC_ALTERNATE_FUNCTIONALITIES = 0x01,
    *ANALOG_INPUT_SINGLE_ENDED = 0x02,
    *DIGITAL_INPUT_MONITORED = 0x03,
    *DIGITAL_OUTPUT_DEFAULT_LOW = 0x04,
    *DIGITAL_OUTPUT_DEFAULT_HIGH = 0x05,
    *ALTERNATE_FUNCTIONALITIES_WHERE_APPLICABLE = 0x06//0x06~0x09
    */
    void setPinFunction(unsigned  char function) { data[4] = function; }
    
};

#endif