#include "Tx16TransmitOptions.h"

Tx16TransmitOptions::Tx16TransmitOptions() { }

Tx16TransmitOptions::Tx16TransmitOptions(unsigned char value):OptionsBase(value)
{ }

Tx16TransmitOptions::Tx16TransmitOptions(bool disable_retries_and_route_repair, bool force_long_header, bool disable_long_header, bool invoke_traceroute)
{
    value = 0x00;
    if (disable_retries_and_route_repair)
        value |= 0x01;
    if (force_long_header)
        value |= 0x02;
    if (disable_long_header)
        value |= 0x04;
    if (invoke_traceroute)
        value |= 0x08;
}

Tx16TransmitOptions * Tx16TransmitOptions::ForceLongHeader = new Tx16TransmitOptions(0x02);

Tx16TransmitOptions * Tx16TransmitOptions::DisableLongHeader = new Tx16TransmitOptions(0x04);

Tx16TransmitOptions * Tx16TransmitOptions::InvokeTraceroute = new Tx16TransmitOptions(0x08);

bool Tx16TransmitOptions::getForceLongHeader()
{
    if ((value & 0x02) == 0x02)
        return true;
    else return false;
}

void Tx16TransmitOptions::setForceLongHeader(bool status)
{
    if (status)
        value |= 0x02;
    else
        value &= 0xFD;
}

bool Tx16TransmitOptions::getDisableLongHeader()
{
    if ((value & 0x04) == 0x04)
        return true;
    else return false;
}

void Tx16TransmitOptions::setDisableLongHeader(bool status)
{
    if (status)
        value |= 0x04;
    else
        value &= 0xFB;
}

bool Tx16TransmitOptions::getInvokeTraceroute()
{
    if ((value & 0x08) == 0x08)
        return true;
    else return false;
}

void Tx16TransmitOptions::setInvokeTraceroute(bool status)
{
    if (status)
        value |= 0x08;
    else
        value &= 0xF7;
}
