#include "ZigBeeIOSampleIndicator.h"

ZigBeeIOSampleIndicator::ZigBeeIOSampleIndicator(APIFrame *frame)
    : RxBase(frame) {}

int ZigBeeIOSampleIndicator::getRSSI()
{
    return 0;
}

IOSamples * ZigBeeIOSampleIndicator::getIOSamples()
{
    return IOSampleDecoder::ZigBeeSamplesParse(data + 12);
    //return samples;
}

int ZigBeeIOSampleIndicator::getSamplesCount()
{
    return data[12];
}

int ZigBeeIOSampleIndicator::getReceiveStatus()
{
    return data[11];
}

Address ZigBeeIOSampleIndicator::getRemoteDevice()
{
    return Address(data + 1);
}

bool  ZigBeeIOSampleIndicator::convert(APIFrame * frame)
{
    if (frame == NULL)
        return false;

    if (frame->getFrameType() != APIFrame::ZigBee_IO_Data_Sample_Rx_Indicator)
        return false;

    return APIFrame::convert(frame);
}