#include "XBeeRx64IOSampleIndicator.h"

XBeeRx64IOSampleIndicator::XBeeRx64IOSampleIndicator(APIFrame *frame)
    : RxBase(frame) {}

int XBeeRx64IOSampleIndicator::getRSSI()
{
    return data[9] * -1;
}

IOSamples * XBeeRx64IOSampleIndicator::getIOSamples()
{
    return IOSampleDecoder::XBeeSamplesParse(data + 11);
    //return samples;
}

int XBeeRx64IOSampleIndicator::getSamplesCount()
{
    return data[11];
}

int XBeeRx64IOSampleIndicator::getReceiveStatus()
{
    return data[10];
}

Address XBeeRx64IOSampleIndicator::getRemoteDevice()
{
    return Address(data + 1 , NULL);
}

bool  XBeeRx64IOSampleIndicator::convert(APIFrame * frame)
{
    if (frame == NULL)
        return false;

    if (frame->getFrameType() != APIFrame::Rx64_IO_Data_Sample_Rx_Indicator)
        return false;

    return APIFrame::convert(frame);
}