#ifndef UK_AC_HERTS_SMARTLAB_XBEE_XBeeRx16Indicator
#define UK_AC_HERTS_SMARTLAB_XBEE_XBeeRx16Indicator

#include "RxBase.h"
#include "Address.h"
#include "IPayloadResponse.h"

class XBeeRx16Indicator: public IPayloadResponse, public RxBase
{
public:
    XBeeRx16Indicator(APIFrame * frame);

    virtual unsigned  char * getReceivedData();

    virtual int getReceivedDataOffset();

    virtual char getReceivedData(int index);

    virtual int getReceivedDataLength();

    virtual int getRSSI();

    /**
    * bit mask
    * SUCCESS = 0x00,
    * PACKET_ACKNOWLEDGED = 0x01,
    * PACKET_WAS_A_BROADCAST = 0x02,
    * PACKET_RECEIVED_ON_BOARDCAST_PAN = 0x04,
    * PACKET_ENCRYPTED_WITH_APS_ENCRYPTION = 0x20,
    * PACKET_WAS_SENT_FROM_AN_END_DEVICE = 0x40,
    */
    virtual int getReceiveStatus();

    virtual Address getRemoteDevice();
    
    bool convert(APIFrame * frame);
};

#endif