#include "XBeeRx16IOSampleIndicator.h"

XBeeRx16IOSampleIndicator::XBeeRx16IOSampleIndicator(APIFrame *frame)
    : RxBase(frame)
{}

int XBeeRx16IOSampleIndicator::getRSSI()
{
    return data[3] * -1;
}

IOSamples * XBeeRx16IOSampleIndicator::getIOSamples()
{
    return IOSampleDecoder::XBeeSamplesParse(data + 5);
    //return samples;
}

int XBeeRx16IOSampleIndicator::getSamplesCount()
{
    return data[5];
}

int XBeeRx16IOSampleIndicator::getReceiveStatus()
{
    return data[4];
}

Address XBeeRx16IOSampleIndicator::getRemoteDevice()
{
    return Address(NULL, data + 1);
}

bool  XBeeRx16IOSampleIndicator::convert(APIFrame * frame)
{
    if (frame == NULL)
        return false;

    if (frame->getFrameType() != APIFrame::Rx16_IO_Data_Sample_Rx_Indicator)
        return false;

    return APIFrame::convert(frame);
}