#include "ZigBeeExplicitTxRequest.h"

ZigBeeExplicitTxRequest::ZigBeeExplicitTxRequest(unsigned  char frameID, ExplicitAddress * remoteAddress, OptionsBase * transmitOptions, const unsigned char * payload, int offset, int length)
    : TxBase(18 + length, APIFrame::Explicit_Addressing_ZigBee_Command_Frame, frameID)
{
    sets(remoteAddress->getAddressValue(), 0, 10);
    sets(remoteAddress->getExplicitValue(), 0, 6);
    set(0x00);
    set(transmitOptions->getValue());
    sets(payload, offset, length);
}

void ZigBeeExplicitTxRequest::setBroadcastRadius(unsigned  char broadcastRadius)
{
    data[18] = broadcastRadius;
}

void ZigBeeExplicitTxRequest::setTransmitOptions(OptionsBase * transmitOptions)
{
    data[19] = transmitOptions->getValue();
}

void ZigBeeExplicitTxRequest::setPayload(const unsigned char * data, int offset, int length)
{
    setPosition(20);
    sets(data, offset, length);
}

void ZigBeeExplicitTxRequest::setRemoteAddress(Address * remoteAddress)
{
    sets(2, remoteAddress->getAddressValue(), 0, 10);
}

void ZigBeeExplicitTxRequest::setRemoteAddress(ExplicitAddress * remoteAddress)
{
    sets(2, remoteAddress->getAddressValue(), 0, 10);
    sets(12, remoteAddress->getExplicitValue(), 0, 6);
}