#include "TransmitOptions.h"

TransmitOptions::TransmitOptions()
    : OptionsBase()
{ }

TransmitOptions::TransmitOptions(unsigned char option)
    : OptionsBase(option)
{ }

TransmitOptions::TransmitOptions(bool disable_retries_and_route_repair, bool enable_APS_encryption, bool use_extended_transmission_timeout)
{
    value = 0x00;
    if (disable_retries_and_route_repair)
        value |= 0x01;
    if (enable_APS_encryption)
        value |= 0x20;
    if (use_extended_transmission_timeout)
        value |= 0x40;
}

TransmitOptions * TransmitOptions::EnableAPS = new TransmitOptions(0x20);

TransmitOptions * TransmitOptions::UseExtendedTimeout = new TransmitOptions(0x40);

bool TransmitOptions::getEnableAPS()
{
    if (value & 0x20 == 0x20)
        return true;
    else return false;
}

void TransmitOptions::setEnableAPS(bool status)
{
    if (status)
        value |= 0x20;
    else
        value &= 0xDF;
}

bool TransmitOptions::getUseExtendedTimeout()
{
    if ((value & 0x40) == 0x40)
        return true;
    else return false;
}

void TransmitOptions::setUseExtendedTimeout(bool status)
{
    if (status)
        value |= 0x40;
    else
        value &= 0xBF;
}
