#ifndef UK_AC_HERTS_SMARTLAB_XBEE_ModemStatusIndicator
#define UK_AC_HERTS_SMARTLAB_XBEE_ModemStatusIndicator

#include "RxBase.h"

class ModemStatusIndicator: public RxBase
{
public:
    ModemStatusIndicator(APIFrame * frame);

    /**
    *
    * @returns
    *
    *        HARDWARE_RESET = 0x00,
    *        WATCHDOG_TIMER_RESET = 0x01,
    *        JOINED_NETWORK = 0x02,
    *        DISASSOCIATED = 0x03,
    *
    *        CONFIGURATION_ERROR = 0x04,
    *        COORDINATOR_REALIGNMENT = 0x05,
    *
    *        COORDINATOR_START = 0x06,
    *        NETWORK_SECURITY_KEY_WAS_UPDATED = 0x07,
    *
    *        NETWORK_WOKE_UP = 0x0B,
    *        NETWORK_WENT_TO_SLEEP = 0x0C,
    *
    *        VOLTAGE_SPPLY_LIMIT_EXCEEDED = 0x0D,
    *        MODEM_CONFIGURATION_CHANGED_WHILE_JOIN_IN_PRIGRESS = 0x11,
    *
    *        //0x80+ STACK_ERROR
    *        STACK_ERROR = 0x80,
    *
    *        SEND_JOIN_ISSIED_WITHOUT_CONNECTING_AP = 0x82,
    *        ACCESS_POINT_NOT_FOUND = 0x83,
    *        PSK_NOT_FOUND = 0x84,
    *        SSID_NOT_FOUND = 0x87,
    *
    *        FAILED_TO_JOIN_WITH_SECURITY_ENABLED = 0x88,
    *        INVALID_CHANNEL = 0x8A,
    *        FAILED_TO_JOIN_ACCESS_POINT = 0x8E,
    *
    */
    int getModemStatus();

    bool convert(APIFrame * frame);
};

#endif