#include "IOSampleDecoder.h"

IOSamples * IOSampleDecoder::samples = NULL;

int IOSampleDecoder::num = 0;

IOSamples * IOSampleDecoder::XBeeSamplesParse(const unsigned  char * IOSamplePayload, int offset)
{
    // at least 3 bytes, 1 byte of [number of samples] + 2 bytes of [digital channel mask] and [analog channel mask].
    int numofsamples = IOSamplePayload[offset];

    if (numofsamples <= 0)
        return NULL;

    if (samples != NULL) {
        if (numofsamples > num) {
            delete[] samples;
            samples = new IOSamples[numofsamples];
        }
    } else samples = new IOSamples[numofsamples];
    num = numofsamples;

    // first byte is the number of sample
    int index = offset + 1;

    int digitMask = ((IOSamplePayload[index] & 0x01) << 8) | IOSamplePayload[index + 1];
    int analogMask = IOSamplePayload[index] & 0xFE;

    // sample start at +2 [mask]
    index += 2;

    for (int i = 0; i < numofsamples; i++) {
        map<Pin *, unsigned int> *  analog = (samples + i)->getAnalogs();
        map<Pin *, unsigned char> *  digital = (samples + i)->getDigitals();
        if (digitMask != 0) {
            if ((digitMask & 0x01) == 0x01)
                (*digital)[XBeePins::P20_AD0_DIO0] = (IOSamplePayload[index + 1] & 0x01) == 0x01 ? 1 : 0;
            if ((digitMask & 0x02) == 0x02)
                (*digital)[XBeePins::P19_AD1_DIO1] = (IOSamplePayload[index + 1] & 0x02) == 0x02 ? 1 : 0;
            if ((digitMask & 0x04) == 0x04)
                (*digital)[XBeePins::P18_AD2_DIO2] = (IOSamplePayload[index + 1] & 0x04) == 0x04 ? 1 : 0;
            if ((digitMask & 0x08) == 0x08)
                (*digital)[XBeePins::P17_AD3_DIO3] = (IOSamplePayload[index + 1] & 0x08) == 0x08 ? 1 : 0;
            if ((digitMask & 0x10) == 0x10)
                (*digital)[XBeePins::P11_AD4_DIO4] = (IOSamplePayload[index + 1] & 0x10) == 0x10 ? 1 : 0;
            if ((digitMask & 0x20) == 0x20)
                (*digital)[XBeePins::P15_ASSOCIATE_AD5_DIO5] = (IOSamplePayload[index + 1] & 0x20) == 0x20 ? 1 : 0;
            if ((digitMask & 0x40) == 0x40)
                (*digital)[XBeePins::P16_RTS_AD6_DIO6] = (IOSamplePayload[index + 1] & 0x40) == 0x40 ? 1 : 0;
            if ((digitMask & 0x80) == 0x80)
                (*digital)[XBeePins::P12_CTS_DIO7] = (IOSamplePayload[index + 1] & 0x80) == 0x80 ? 1 : 0;
            if (((digitMask >> 8) & 0x01) == 0x01)
                (*digital)[XBeePins::P9_DTR_SLEEP_DIO8] = (IOSamplePayload[index] & 0x01) == 0x01 ? 1 : 0;

            //skip the 2 [digital sample]
            index += 2;
        }

        if (analogMask != 0) {
            if ((analogMask & 0x02) == 0x02) {
                (*analog)[XBeePins::P20_AD0_DIO0] = IOSamplePayload[index] << 8 | IOSamplePayload[index+1];
                index+=2;
            }
            if ((analogMask & 0x04) == 0x04) {
                (*analog)[XBeePins::P19_AD1_DIO1] = IOSamplePayload[index] << 8 | IOSamplePayload[index+1];
                index+=2;
            }

            if ((analogMask & 0x08) == 0x08) {
                (*analog)[XBeePins::P18_AD2_DIO2] = IOSamplePayload[index] << 8 | IOSamplePayload[index+1];
                index+=2;
            }

            if ((analogMask & 0x10) == 0x10) {
                (*analog)[XBeePins::P17_AD3_DIO3] = IOSamplePayload[index] << 8 | IOSamplePayload[index+1];
                index+=2;
            }

            if ((analogMask & 0x20) == 0x20) {
                (*analog)[XBeePins::P11_AD4_DIO4] = IOSamplePayload[index] << 8 | IOSamplePayload[index+1];
                index+=2;
            }

            if ((analogMask & 0x40) == 0x40) {
                (*analog)[XBeePins::P15_ASSOCIATE_AD5_DIO5] = IOSamplePayload[index] << 8 | IOSamplePayload[index+1];
                index+=2;
            }
        }
    }

    return samples;
}

IOSamples * IOSampleDecoder::ZigBeeSamplesParse(const unsigned  char * IOSamplePayload, int offset)
{
    // at least 4 bytes, 1 byte of [number of samples] + 2 bytes of [digital channel mask] + 1 bytes of [analog channel mask].

    // the [number of samples] always set to 1.
    int numofsamples = IOSamplePayload[offset];

    if (numofsamples <= 0)
        return NULL;

    if (samples != NULL) {
        if (numofsamples > num) {
            delete[] samples;
            samples = new IOSamples[numofsamples];
        }
    } else samples = new IOSamples[numofsamples];
    num = numofsamples;
    
    int index = offset + 1;

    int digitMask = (IOSamplePayload[index++] << 8) | IOSamplePayload[index++];
    int analogMask = IOSamplePayload[index++];

    for (int i = 0; i < numofsamples; i++) {
        map<Pin *, unsigned int> *  analog = (samples + i)->getAnalogs();
        map<Pin *, unsigned char> *  digital = (samples + i)->getDigitals();

        if (digitMask != 0) {
            if ((digitMask & 0x01) == 0x01)
                (*digital)[ZigBeePins::P20_AD0_DIO0_COMMISSIONONG_BUTTON] = (IOSamplePayload[index + 1] & 0x01) == 0x01 ? 1 : 0;
            if ((digitMask & 0x02) == 0x02)
                (*digital)[ZigBeePins::P19_AD1_DIO1] = (IOSamplePayload[index + 1] & 0x02) == 0x02 ? 1 : 0;
            if ((digitMask & 0x04) == 0x04)
                (*digital)[ZigBeePins::P18_AD2_DIO2] = (IOSamplePayload[index + 1] & 0x04) == 0x04 ? 1 : 0;
            if ((digitMask & 0x08) == 0x08)
                (*digital)[ZigBeePins::P17_AD3_DIO3] = (IOSamplePayload[index + 1] & 0x08) == 0x08 ? 1 : 0;
            if ((digitMask & 0x10) == 0x10)
                (*digital)[ZigBeePins::P11_DIO4] = (IOSamplePayload[index + 1] & 0x10) == 0x10 ? 1 : 0;
            if ((digitMask & 0x20) == 0x20)
                (*digital)[ZigBeePins::P15_ASSOCIATE_DIO5] = (IOSamplePayload[index + 1] & 0x20) == 0x20 ? 1 : 0;
            if ((digitMask & 0x40) == 0x40)
                (*digital)[ZigBeePins::P16_RTS_DIO6] = (IOSamplePayload[index + 1] & 0x40) == 0x40 ? 1 : 0;
            if ((digitMask & 0x80) == 0x80)
                (*digital)[ZigBeePins::P12_CTS_DIO7] = (IOSamplePayload[index + 1] & 0x80) == 0x80 ? 1 : 0;

            if (((digitMask >> 8) & 0x04) == 0x04)
                (*digital)[ZigBeePins::P6_RSSI_PWM_DIO10] = (IOSamplePayload[index] & 0x04) == 0x04 ? 1 : 0;
            if (((digitMask >> 8) & 0x08) == 0x08)
                (*digital)[ZigBeePins::P7_PWM_DIO11] = (IOSamplePayload[index] & 0x08) == 0x08 ? 1 : 0;
            if (((digitMask >> 8) & 0x10) == 0x10)
                (*digital)[ZigBeePins::P4_DIO12] = (IOSamplePayload[index] & 0x10) == 0x10 ? 1 : 0;

            index += 2;// 2 [digital sample]
        }
        if (analogMask != 0x00) { //analog mask
            if ((analogMask & 0x01) == 0x01){
                (*analog)[ZigBeePins::P20_AD0_DIO0_COMMISSIONONG_BUTTON] = (IOSamplePayload[index] << 8) | IOSamplePayload[index+1];
                index+=2;
            }

            if ((analogMask & 0x02) == 0x02){
                (*analog)[ZigBeePins::P19_AD1_DIO1] = (IOSamplePayload[index] << 8) | IOSamplePayload[index+1];
                index+=2;
            }

            if ((analogMask & 0x04) == 0x04){
                (*analog)[ZigBeePins::P18_AD2_DIO2] = (IOSamplePayload[index] << 8) | IOSamplePayload[index+1];
                index+=2;
            }

            if ((analogMask & 0x08) == 0x08){
                (*analog)[ZigBeePins::P17_AD3_DIO3] = (IOSamplePayload[index] << 8) | IOSamplePayload[index+1];
                index+=2;
            }

            if ((analogMask & 0x80) == 0x80){
                (samples + i)->setSupplyVoltage((IOSamplePayload[index] << 8) | IOSamplePayload[index+1]);
                index+=2;
            }
        }
    }

    return samples;
}