#ifndef UK_AC_HERTS_SMARTLAB_XBEE_XBeePins
#define UK_AC_HERTS_SMARTLAB_XBEE_XBeePins

#include "Pin.h"

/**
* Pin configuration information for XBee S1 modules.
*/
class XBeePins
{
public:
    /** Power supply.
    * Poor power supply can lead to poor radio performance, especially if the supply voltage is not kept within tolerance or is excessively noisy. To help reduce noise, we recommend placing a 1.0 μF and 8.2 pF capacitor as near as possible to pin 1 on the XBee. If using a switching regulator for the power supply, switching frequencies above 500 kHz are preferred. Power supply ripple should be limited to a maximum 100 mV peak to peak.
    */
    static Pin * P1_VCC;

    /// DOUT, Output, UART data out.
    static Pin * P2_DOUT;

    /// DIN / CONFIG(active low), Input, UART data In.
    static Pin * P3_DIN_CONFIG;

    /// DO8, Either, Digital output 8, Function is not supported at the time of this release(18/05/2015).
    static Pin * P4_DO8;

    /// RESET(active low), Input, Module reset (reset pulse must be at least 200 ns).
    static Pin * P5_RESET;

    /// PWM0 / RSSI, Either, PWM output 0 / RX signal strength indicator.
    static Pin * P6_RSSI_PWM0;

    /// PWM1, Either, PWM output 1.
    static Pin * P7_PWM1;

    /// Reserved, Do not connect.
    static Pin * P8_RESERVED;

    /// DTR(active low) / SLEEP_RQ/ DI8, Either, Pin sleep control line or digital input 8.
    static Pin * P9_DTR_SLEEP_DIO8;

    /// Ground.
    static Pin * P10_GND;

    /// AD4 / DIO4, Either, Analog input 4 or digital I/O 4.
    static Pin * P11_AD4_DIO4;

    /// CTS(active low) / DIO7 Either Clear-to-send flow control or digital I/O 7.
    static Pin * P12_CTS_DIO7;

    /// ON / SLEEP(active low), Output, Module status indicator
    static Pin * P13_ON_SLEEP;

    /// VREF, Input, Voltage reference for A/D inputs.
    static Pin * P14_VREF;

    /// Associate / AD5 / DIO5, Either, Associated indicator, analog input 5 or digital I/O 5.
    static Pin * P15_ASSOCIATE_AD5_DIO5;

    /// RTS(active low) / DIO6, Either, Request-to-send flow control, or digital I/O 6.
    static Pin * P16_RTS_AD6_DIO6;

    /// AD3 / DIO3 Either Analog input 3 or digital I/O 3.
    static Pin * P17_AD3_DIO3;

    /// AD2 / DIO2 Either Analog input 2 or digital I/O 2.
    static Pin * P18_AD2_DIO2;

    /// AD1 / DIO1 Either Analog input 1 or digital I/O 1.
    static Pin * P19_AD1_DIO1;

    /// AD0 / DIO0 Either Analog input 0, digital I/O 0.
    static Pin * P20_AD0_DIO0;
};

#endif