#include "Pin.h"

unsigned char Pin::bitfield[2] = {0,0};

Pin::Pin(unsigned char number)
{
    num = number;
}

Pin::Pin(unsigned char number, const char * command, unsigned int changeDetection)
{
    num = number;
    com[0] = command[0];
    com[1] = command[2];
    IODet[0] = changeDetection >> 8;
    IODet[1] = changeDetection;
}

unsigned char Pin::getNumber()
{
    return num;
}

const char * Pin::getCommand()
{
    return com;
}

const unsigned char * Pin::IOChangeDetectionConfiguration(Pin ** pins, unsigned char size)
{
    Pin::bitfield[0] = 0;
    Pin::bitfield[1] = 0;
    for (int i = 0; i < size; i++) {
        Pin::bitfield[0] |= pins[i]->IODet[0];
        Pin::bitfield[1] |= pins[i]->IODet[1];
    }
    return Pin::bitfield;
}

const unsigned char * Pin::getIODetection()
{
    return IODet;
}

bool operator ==(const Pin &a,const Pin &b)
{
    return a.num == b.num;
}

bool operator !=(const Pin &a,const Pin &b)
{
    return !(a==b);
}