#ifndef UK_AC_HERTS_SMARTLAB_XBEE_ExplicitAddress
#define UK_AC_HERTS_SMARTLAB_XBEE_ExplicitAddress

#include "Address.h"

/// ZigBeee address class for S2 hardware
class ExplicitAddress : public Address
{
private:
    /// total 6 bytes : 1 byte of SourceEndpoint + 1 byte of DestinationEndpoint + 2 bytes of ClusterID + 2 bytes of ProfileID
    unsigned char explicitValue[6];

public:
    /**
    * Create a XBee explicit address, with all the value with defatul 0x00
    */
    ExplicitAddress();

    /**
    * Create explicit address from existing byte aray value.
    * @param addressValue 10 bytes (8 bytes of IEEE address + 2 bytes of network address)
    * @param explicitValue 6 bytes : 1 byte of SourceEndpoint + 1 byte of DestinationEndpoint + 2 bytes of ClusterID + 2 bytes of ProfileID
    */
    ExplicitAddress (const unsigned  char * addressValue, const unsigned  char * explicitValue );

    /**
    * Create address from existing value.
    * @param serialNumberHigh
    * @param serialNumberLow
    * @param networkAddress
    * @param sourceEndpoint
    * @param destinationEndpoint
    * @param clusterID
    * @param profileID
    */
    ExplicitAddress(long serialNumberHigh, long serialNumberLow, int networkAddress, int sourceEndpoint, int destinationEndpoint, int clusterID, int profileID);

    /**
    * total 6 bytes/
    * 1 byte of SourceEndpoint + 1 byte of DestinationEndpoint + 2 bytes of ClusterID + 2 bytes of ProfileID
    */
    unsigned  char * getExplicitValue();

    unsigned char getSourceEndpoint();

    void setSourceEndpoint(unsigned char SourceEndpoint);

    unsigned char getDestinationEndpoint();

    void setDestinationEndpoint(unsigned char DestinationEndpoint);

    unsigned int getClusterID();

    void setClusterID(unsigned int ClusterID);

    unsigned int getProfileID();

    void setProfileID(unsigned int ProfileID);
};

#endif