#include "Address.h"

Address * Address::BROADCAST_ZIGBEE = new Address(0x00000000, 0x0000FFFF, 0xFFFE);
Address * Address::BROADCAST_XBEE = new Address(0x00000000, 0x00000000, 0xFFFF);

Address::Address() {}

Address::Address(const unsigned  char * address64, const unsigned  char * NET16)
{
    if (address64 != NULL)
        memcpy(value,address64,8);

    if (NET16 != NULL) {
        value[8] = NET16[0];
        value[9] = NET16[1];
    }
}

Address::Address(const unsigned  char * addr)
{
    if (addr != NULL)
        memcpy(value,addr,10);
}

Address::Address(long serialNumberHigh, long serialNumberLow, int networkAddress)
{
    setSerialNumberHigh(serialNumberHigh);
    setSerialNumberLow(serialNumberLow);
    setNetworkAddress(networkAddress);
}

unsigned long Address::getSerialNumberHigh()
{
    return (value[0] << 24) | (value[1] << 16) | (value[2] << 8) | value[3];
}

unsigned long Address::getSerialNumberLow()
{
    return (value[4] << 24) | (value[5] << 16) | (value[6] << 8) | value[7];
}

unsigned int Address::getNetworkAddress()
{
    return (value[8] << 8) | value[9];
}

void Address::setSerialNumberHigh(long serialNumberHigh)
{
    value[0] = serialNumberHigh >> 24;
    value[1] = serialNumberHigh >> 16;
    value[2] = serialNumberHigh >> 8;
    value[3] = serialNumberHigh;
}

void Address::setSerialNumberLow(long serialNumberLow)
{
    value[4] = serialNumberLow >> 24;
    value[5] = serialNumberLow >> 16;
    value[6] = serialNumberLow >> 8;
    value[7] = serialNumberLow;
}

void Address::setNetworkAddress(int networkAddress)
{
    value[8] = networkAddress >> 8;
    value[9] = networkAddress;
}

const unsigned  char * Address::getAddressValue()
{
    return value;
}

bool operator ==(const Address &a,const Address &b)
{
    for (uint8_t i = 0; i < 8; i++)
        if (a.value[i] != b.value[i])
            return false;
    return true;
}

bool operator !=(const Address &a,const Address &b)
{
    return !(a==b);
}
