#ifndef UK_AC_HERTS_SMARTLAB_XBEE_APIFrame
#define UK_AC_HERTS_SMARTLAB_XBEE_APIFrame

#include "BufferedArray.h"

/// An API frame is the structured data sent and received through the serial interface of the radio module when it is configured in API or API escaped operating modes. API frames are used to communicate with the module or with other modules in the network.
class APIFrame : public BufferedArray
{
private:
    /// Checksum value for the API fram.
    unsigned char checkSum;

    /// A state to indicate whether this packet's checksum is verified while process.
    bool isVerify;

public:
    static const unsigned char Tx64_Request =0x00;
    static const unsigned char Tx16_Request =0x01;
    static const unsigned char AT_Command = 0x08;
    static const unsigned char AT_Command_Queue_Parameter_Value = 0x09;
    static const unsigned char ZigBee_Transmit_Request = 0x10;
    static const unsigned char Explicit_Addressing_ZigBee_Command_Frame = 0x11;
    static const unsigned char Remote_Command_Request = 0x17;
    static const unsigned char Create_Source_Route = 0x21;
    static const unsigned char Register_Joining_Device = 0x24;
    static const unsigned char Rx64_Receive_Packet = 0x80;
    static const unsigned char Rx16_Receive_Packet = 0x81;
    static const unsigned char Rx64_IO_Data_Sample_Rx_Indicator = 0x82;
    static const unsigned char Rx16_IO_Data_Sample_Rx_Indicator = 0x83;
    static const unsigned char AT_Command_Response = 0x88;
    static const unsigned char XBee_Transmit_Status = 0x89;
    static const unsigned char Modem_Status = 0x8A;
    static const unsigned char ZigBee_Transmit_Status = 0x8B;
    static const unsigned char ZigBee_Receive_Packet = 0x90;
    static const unsigned char ZigBee_Explicit_Rx_Indicator = 0x91;
    static const unsigned char ZigBee_IO_Data_Sample_Rx_Indicator = 0x92;
    static const unsigned char XBee_Sensor_Read_Indicato = 0x94;
    static const unsigned char Node_Identification_Indicator = 0x95;
    static const unsigned char Remote_Command_Response = 0x97;
    static const unsigned char Over_the_Air_Firmware_Update_Status = 0xA0;
    static const unsigned char Route_Record_Indicator = 0xA1;
    static const unsigned char Device_Authenticated_Indicator = 0xA2;
    static const unsigned char Many_to_One_Route_Request_Indicator = 0xA3;

    static const unsigned char StartDelimiter = 0x7E;

    APIFrame(unsigned int payloadLength);

    APIFrame(APIFrame * frame);

    /** Get the API frame type.
    *
    * @returns
    *    Tx64_Request =0x00,
    *    Tx16_Request =0x01,
    *    AT_Command = 0x08,
    *    AT_Command_Queue_Parameter_Value = 0x09,
    *    ZigBee_Transmit_Request = 0x10,
    *    Explicit_Addressing_ZigBee_Command_Frame = 0x11,
    *    Remote_Command_Request = 0x17,
    *    Create_Source_Route = 0x21,
    *    Register_Joining_Device = 0x24,
    *    Rx64_Receive_Packet = 0x80,
    *    Rx16_Receive_Packet = 0x81,
    *    Rx64_IO_Data_Sample_Rx_Indicator = 0x82,
    *    Rx16_IO_Data_Sample_Rx_Indicator = 0x83,
    *    AT_Command_Response = 0x88,
    *    XBee_Transmit_Status = 0x89,
    *    Modem_Status = 0x8A,
    *    ZigBee_Transmit_Status = 0x8B,
    *    ZigBee_Receive_Packet = 0x90,
    *    ZigBee_Explicit_Rx_Indicator = 0x91,
    *    ZigBee_IO_Data_Sample_Rx_Indicator = 0x92,
    *    XBee_Sensor_Read_Indicato = 0x94,
    *    Node_Identification_Indicator = 0x95,
    *    Remote_Command_Response = 0x97,
    *    Over_the_Air_Firmware_Update_Status = 0xA0,
    *    Route_Record_Indicator = 0xA1,
    *    Device_Authenticated_Indicator = 0xA2,
    *    Many_to_One_Route_Request_Indicator = 0xA3,
    */
    unsigned char getFrameType();

    void setFrameType(unsigned char identifier);

    void allocate(unsigned long length);

    void rewind();
    
    bool convert(APIFrame * frame);

    /** Write 8-bit data into current posiston and increase by 1.
    * @param value sigle byte
    */
    void set(unsigned char value);

    /** Write array of data into current posiston, and increase by the lenght.
    * @param value array of byte
    * @param offset start point of the data
    * @param length length to write
    */
    void sets(const unsigned char * value, unsigned long offset, unsigned long length);

    /** Write 8-bit data into specific posiston and deos not affect the current position.
    * @param position where to write
    * @param value sigle byte
    */
    void set(unsigned long position, unsigned  char value);

    /** Write array of data into specific posiston and deos not affect the current position.
    * @param position where to write
    * @param value array of byte
    * @param offset start point of the data
    * @param length length to write
    */
    void sets(unsigned long position, const unsigned char * value, unsigned long offset, unsigned long length);

    /** Get checksum.
    * @returns the checksum value
    */
    char getCheckSum();

    /** Set checksum.
    * @param value checksum value
    */
    void setCheckSum(unsigned char value);

    /** Check is the API frame's checksum is verified.
    * @returns true checksum match,
    *          false checksum not match
    */
    bool verifyChecksum();

    /// Calculate the checksum value.
    void calculateChecksum();
};

#endif