#include "APIFrame.h"

APIFrame::APIFrame(unsigned int payloadLength)
    :BufferedArray(payloadLength, 10)
{}

APIFrame::APIFrame(APIFrame * frame)
    :BufferedArray(frame)
{
    if (frame != NULL) {
        this->checkSum = frame->checkSum;
        this->isVerify = frame->isVerify;
    }
}

unsigned char APIFrame::getFrameType()
{
    return data[0];
}

void APIFrame::setFrameType(unsigned char identifier)
{
    data[0] = identifier;
}

void APIFrame::allocate(unsigned long length)
{
    BufferedArray::allocate(length);
    isVerify = false;
}

void APIFrame::rewind()
{
    BufferedArray::rewind();
    isVerify = false;
}

bool APIFrame::convert(APIFrame * frame)
{
    if (frame == NULL)
        return false;

    this->data = frame->data;
    this->index = frame->index;
    this->max = frame->max;
    this->checkSum = frame->checkSum;
    this->isVerify = frame->isVerify;
    return true;
}

void APIFrame::set(unsigned char value)
{
    BufferedArray::set(value);
    isVerify = false;
}

void APIFrame::sets(const unsigned char * value, unsigned long offset, unsigned long length)
{
    BufferedArray::sets(value, offset, length);
    isVerify = false;
}

void APIFrame::set(unsigned long position, unsigned char value)
{
    BufferedArray::set(position, value);
    isVerify = false;
}

void APIFrame::sets(unsigned long position, const unsigned char * value, unsigned long offset, unsigned long length)
{
    BufferedArray::sets(position, value, offset, length);
    isVerify = false;
}

char APIFrame::getCheckSum()
{
    return checkSum;
}

void APIFrame::setCheckSum(unsigned char value)
{
    checkSum = value;
}

bool APIFrame::verifyChecksum()
{
    if (isVerify)
        return true;

    char temp = 0x00;
    for (int i = 0; i < index; i++)
        temp += data[i];
    if (temp + checkSum == 0xFF)
        isVerify = true;
    else
        isVerify = false;

    return isVerify;
}

void APIFrame::calculateChecksum()
{
    if (isVerify)
        return;

    char CS = 0x00;
    for (int i = 0; i < index; i++)
        CS += data[i];
    checkSum = 0xFF - CS;
    isVerify = true;
}