#include "SerialData.h"

SerialData::SerialData(PinName tx, PinName rx)
{
    serialPort = new Serial(tx, rx);
    serialPort->baud(9600);
}

SerialData::SerialData(PinName tx, PinName rx, int baudRate)
{
    serialPort = new Serial(tx, rx);
    serialPort->baud(baudRate);
}

SerialData::~SerialData()
{
    if (serialPort != NULL)
        delete serialPort;
}

int SerialData::readByte()
{
    return serialPort->getc();
}

void SerialData::writeByte(char data)
{
    serialPort->putc(data);
}

bool SerialData::peek()
{
    if (serialPort->readable())
        return true;
    else return false;
}

bool SerialData::isOpen()
{
    return true;
}

void SerialData::open()
{}

void SerialData::close()
{}