#ifndef UK_AC_HERTS_SMARTLAB_XBEE_API
#define UK_AC_HERTS_SMARTLAB_XBEE_API

#include "mbed.h"
#include "SerialData.h"
#include "CoreAPI.h"

/** XBee API library entry poiont.
* Example:
* @code
* #include "mbed.h"
* #include "XBeeAPI.h"
*
* XBeeAPI xbee(p9, p10, true);
* Address add(0x0013A200,0x406CABD,0x0456);
* XBeeTx16Request tx16(0x00, &add, OptionsBase::DEFAULT, "Hello From XBEE API", 0, 19);
* XBeeRx16Indicator rx16(NULL);
*
* int main()
* {
*    xbee.setVerifyChecksum(false);
*
*    // option 1
*    while(1) {
*        XBeeRx16Indicator * response = xbee.getXBeeRx16();
*        if (response != NULL) {
*            tx16.setPayload(response->getReceivedData(), 0, response->getReceivedDataLength());
*            xbee.send(&tx16);
*        }
*    }
*
*    // option 2
*    while(1) {
*
*        APIFrame * frame = xbee.getResponse();
*        while(frame != NULL) {
*            switch (frame->getFrameType()) {
*                case APIFrame::Tx64_Request :
*                    break;
*                case APIFrame::Tx16_Request :
*                    break;
*                case APIFrame::AT_Command:
*                    break;
*                case APIFrame::AT_Command_Queue_Parameter_Value:
*                    break;
*                case APIFrame::ZigBee_Transmit_Request:
*                    break;
*                case APIFrame::Explicit_Addressing_ZigBee_Command_Frame:
*                    break;
*                case APIFrame::Remote_Command_Request :
*                    break;
*                case APIFrame::Create_Source_Route :
*                    break;
*                case APIFrame::Register_Joining_Device:
*                    break;
*                case APIFrame::Rx64_Receive_Packet :
*                    break;
*                case APIFrame::Rx16_Receive_Packet:
*                    rx16.convert(frame);
*                    tx16.setPayload(rx16.getReceivedData(), 0, rx16.getReceivedDataLength());
*                    xbee.send(&tx16);
*                    break;
*                case APIFrame::Rx64_IO_Data_Sample_Rx_Indicator:
*                    break;
*                case APIFrame::Rx16_IO_Data_Sample_Rx_Indicator :
*                    xbee.send(&tx16);
*                    break;
*                case APIFrame::AT_Command_Response:
*                    break;
*                case APIFrame::XBee_Transmit_Status :
*                    break;
*                case APIFrame::Modem_Status:
*                    break;
*                case APIFrame::ZigBee_Transmit_Status :
*                    break;
*                case APIFrame::ZigBee_Receive_Packet:
*                    break;
*                case APIFrame::ZigBee_Explicit_Rx_Indicator :
*                    break;
*                case APIFrame::ZigBee_IO_Data_Sample_Rx_Indicator :
*                    break;
*                case APIFrame::XBee_Sensor_Read_Indicato :
*                    break;
*                case APIFrame::Node_Identification_Indicator:
*                    break;
*                case APIFrame::Remote_Command_Response:
*                    break;
*                case APIFrame::Over_the_Air_Firmware_Update_Status :
*                    break;
*                case APIFrame::Route_Record_Indicator :
*                    break;
*                case APIFrame::Device_Authenticated_Indicator:
*                    break;
*                case APIFrame::Many_to_One_Route_Request_Indicator:
*                    break;
*            }
*
*            frame = xbee.getResponse();
*        }
*    }
* }
* @endcode
*/
class XBeeAPI: public CoreAPI
{
public:

    /** Create a XBeeAPI instance, with baud rate 9600 and no escape.
    *
    * @param tx data transmission line
    * @param rx data receiving line
    *
    */
    XBeeAPI(PinName tx, PinName rx);

    /** Create a XBeeAPI instance, with baud rate 9600.
    *
    * @param tx data transmission line
    * @param rx data receiving line
    * @param isEscape API escaped operating mode (AP = 2) works similarly to API mode. The only difference is that when working in API escaped mode, some bytes of the API frame specific data must be escaped.
    *
    */
    XBeeAPI(PinName tx, PinName rx, bool isEscape);

    /** Create a XBeeAPI instance. 
    *
    * @param tx data transmission line
    * @param rx data receiving line
    * @param baudRate baud rate
    * @param isEscape API escaped operating mode (AP = 2) works similarly to API mode. The only difference is that when working in API escaped mode, some bytes of the API frame specific data must be escaped.
    *
    */
    XBeeAPI(PinName tx, PinName rx, int baudRate, bool isEscape);

    /** Create a SerialData instance with other serial interface.
    *
    * @param serial class that implementes ISerial interface.
    * @param baudRate baud rate
    * @param isEscape API escaped operating mode (AP = 2) works similarly to API mode. The only difference is that when working in API escaped mode, some bytes of the API frame specific data must be escaped.
    *
    */
    XBeeAPI(ISerial * serial, bool isEscape);
};

#endif