#include "XBeeTx16Request.h"

XBeeTx16Request::XBeeTx16Request(unsigned  char frameID, Address * remoteAddress, OptionsBase * transmitOptions, const unsigned  char * payload, int offset, int length)
    : TxBase(3 + length, APIFrame::Tx16_Request, frameID)
{
    set(remoteAddress->getNetworkAddress() >> 8);
    set(remoteAddress->getNetworkAddress());
    set(transmitOptions->getValue());
    sets(payload, offset, length);
}

void XBeeTx16Request::setPayload(const unsigned char * data, int offset, int length)
{
    setPosition(5);
    sets(data, offset, length);
}

void XBeeTx16Request::setTransmitOptions(OptionsBase * transmitOptions)
{
    data[4] = transmitOptions->getValue();
}

void XBeeTx16Request::setRemoteAddress(Address * remoteAddress)
{
    data[2] = remoteAddress->getNetworkAddress() >> 8;
    data[3] = remoteAddress->getNetworkAddress();
}