#ifndef UK_AC_HERTS_SMARTLAB_XBEE_RemotePinConfigurationRequest
#define UK_AC_HERTS_SMARTLAB_XBEE_RemotePinConfigurationRequest

#include "Pin.h"
#include "Address.h"
#include "ATCommands.h"
#include "RemoteATCommandRequest.h"

class RemotePinConfigurationRequest : public RemoteATCommandRequest
{
public:
    /**
    * @param function
    *DISABLED = 0x00,
    *RESERVED_FOR_PIN_SPECIFIC_ALTERNATE_FUNCTIONALITIES = 0x01,
    *ANALOG_INPUT_SINGLE_ENDED = 0x02,
    *DIGITAL_INPUT_MONITORED = 0x03,
    *DIGITAL_OUTPUT_DEFAULT_LOW = 0x04,
    *DIGITAL_OUTPUT_DEFAULT_HIGH = 0x05,
    *ALTERNATE_FUNCTIONALITIES_WHERE_APPLICABLE = 0x06//0x06~0x09
    */
    RemotePinConfigurationRequest(unsigned char frameID,  Address * remoteAddress, Pin * pin, unsigned char function)
        : RemoteATCommandRequest(frameID, remoteAddress, pin->getCommand(), RemoteCommandOptions::ApplyChanges, &function, 0, 1)
    { }
    
    /**
    * @param function
    *DISABLED = 0x00,
    *RESERVED_FOR_PIN_SPECIFIC_ALTERNATE_FUNCTIONALITIES = 0x01,
    *ANALOG_INPUT_SINGLE_ENDED = 0x02,
    *DIGITAL_INPUT_MONITORED = 0x03,
    *DIGITAL_OUTPUT_DEFAULT_LOW = 0x04,
    *DIGITAL_OUTPUT_DEFAULT_HIGH = 0x05,
    *ALTERNATE_FUNCTIONALITIES_WHERE_APPLICABLE = 0x06//0x06~0x09
    */
    void setPinFunction(unsigned  char function) { data[15] = function; }
};

#endif