#ifndef UK_AC_HERTS_SMARTLAB_XBEE_Tx64TransmitOptions
#define UK_AC_HERTS_SMARTLAB_XBEE_Tx64TransmitOptions

#include "OptionsBase.h"

class Tx64TransmitOptions : public OptionsBase
{
    //0x01 - Disable retries and route repair (XTEND and XBEE)
    //0x02 - Don't repeat this packet (not implemented)
    //0x04 - Send packet with Broadcast Pan ID (XBEE only)
    //0x08 - Invoke Traceroute (XTEND version 8030 only)
    //0x10 (XB868DP) If the packet would be delayed due to duty cycle then purge it. All other bits must be set to 0
public:
    Tx64TransmitOptions();

    Tx64TransmitOptions(unsigned char vlaue);

    Tx64TransmitOptions(bool disable_retries_and_route_repair, bool donot_repeat_packet, bool send_packet_with_broadcast_PanID, bool invoke_traceroute, bool purge_packet_if_delayed_due_to_duty_cycle);

    static Tx64TransmitOptions * DonotRepeatPacket;

    static Tx64TransmitOptions * SendPacketWithBroadcastPanID;

    static Tx64TransmitOptions * InvokeTraceroute;

    static Tx64TransmitOptions * PurgePacketWhenDelayed;

    bool getDonotRepeatPacket();

    void setDonotRepeatPacket(bool status);

    bool getSendPacketWithBroadcastPanID();

    void setSendPacketWithBroadcastPanID(bool status);

    bool getInvokeTraceroute();

    void setInvokeTraceroute(bool status);

    bool getPurgePacketWhenDelayed();

    void setPurgePacketWhenDelayed(bool status);
};

#endif